# Visualizer: Tables and Charts Manager for WordPress # #
**Contributors:** [codeinwp](https://profiles.wordpress.org/codeinwp), [marius2012](https://profiles.wordpress.org/marius2012), [marius_codeinwp](https://profiles.wordpress.org/marius_codeinwp), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani), [themeisle](https://profiles.wordpress.org/themeisle), [Madalin_ThemeIsle](https://profiles.wordpress.org/Madalin_ThemeIsle), [contactashish13](https://profiles.wordpress.org/contactashish13)  
**Tags:** chart, charts, charting, graph, graphs, graphing, visualisation, visualise data, visualization, visualize data, HTML5, canvas, pie chart, line chart, bar chart, column chart, gauge chart, area chart, scatter chart, candlestick chart, geo chart, google visualization api, data tables  
**Requires at least:** 3.5  
**Tested up to:** 5.2  
**Stable tag:** trunk  
**License:** GPL v2.0 or later  
**License URI:** http://www.opensource.org/licenses/gpl-license.php  

A simple and quite powerful WordPress chart plugin to create and embed interactive charts & tables into your site.

## Description ##
 
<a href="http://themeisle.com/plugins/visualizer-charts-and-graphs-lite/" rel="nofollow">Visualizer: Tables and Charts Manager for WordPress (Lite) plugin</a> is a simple, easy to use and quite powerful tool to create, manage and embed interactive charts & tables into your WordPress posts and pages.

The plugin uses Google Visualization API and DataTables.net to add responsive & animated charts/diagrams, which support cross-browser compatibility (adopting VML for older IE versions) and cross-platform portability to iOS and new Android releases. Is the best Excel to WordPress solution who let's you insert charts to your wp site using a simple chart builder.

> **Time-saving features available in the Pro version:**
>
> * Import data from other charts
> * Easy edit the data using a live editor
> * 2 more chart types ( Combo and Timeline )
> * Additional options for some charts
> * Auto synchronize with your online file.
> * Create private charts.
> * Allow users to edit charts.
> * Create charts from your wordpress posts, pages,products or any other post_type.
> * Priority email support from the developer of the plugin
> * Support and updates for 1 year
>
> **[Learn more about Visualizer PRO](http://themeisle.com/plugins/visualizer-charts-and-graphs/)**


### 9 Chart types + 3 more in the pro version ###
This WordPress graph plugin provides a variety of charts that are optimized to address your WordPress data visualization needs. It is line chart,flow chart, area chart, bar chart, column chart, pie chart, geo chart, gauge chart, candlestick chart and scatter chart. These charts are based on pure HTML5/SVG technology (adopting VML for old IE versions), so no extra plugins are required. Adding these charts to your page can be done in a few simple steps. The premium version can act as a interactive WordPress Table plugin, with sorting capabilities.

### Flexible and customizable ###
Make the charts your own. Configure an extensive set of options to perfectly match the look and feel of your website. You can use Google Chart Tools with their default setting - all customization is optional and the basic setup is launch-ready. However, charts can be easily customizable in case your webpage adopts a style which is at odds with provided defaults. Every chart exposes a number of options that customize its look and feel.

### HTML5/SVG ###
Charts are rendered using HTML5/SVG technology to provide cross-browser compatibility (including VML for older IE versions) and cross platform portability to iPhones, iPads and Android. Your users will never have to mess with extra plugins or any software. If they have a web browser, they can see your charts.

*above descriptions were partially taken from Google Visualization API site*

The plugins works perfectly with the all <a href="http://justfreethemes.com" rel="nofollow">free</a> or <a href="http://www.codeinwp.com/blog/best-wordpress-themes/" rel="nofollow">premium WordPress themes</a>


 = See how Visualizer can integrate with your website  =

* [Create line chart ](https://demo.themeisle.com/visualizer/line-chart/)
* [Create pie chart ](https://demo.themeisle.com/visualizer/pie-chart/)
* [Create bar chart](https://demo.themeisle.com/visualizer/bar-chart/)
* [Create column chart](https://demo.themeisle.com/visualizer/column-chart/)
* [Create area chart](https://demo.themeisle.com/visualizer/area-chart/)
* [Create geo chart](https://demo.themeisle.com/visualizer/geo-chart/)
* [Create table chart](https://demo.themeisle.com/visualizer/table-chart/)
* [Create gauge chart](https://demo.themeisle.com/visualizer/gauge-chart//)
* [Create candlestick chart](https://demo.themeisle.com/visualizer/candlestick-chart/)
* [Create combo chart](https://demo.themeisle.com/visualizer/combo-chart/)
* [Create scatter chart](https://demo.themeisle.com/visualizer/scatter-chart/)
* [Create timeline chart](https://demo.themeisle.com/visualizer/timeline-chart/)
* [Chart using frontend action links](https://demo.themeisle.com/visualizer/frontend-action-links/)


## Installation ##

1. Upload the files to the `/wp-content/plugins/visualizer/` directory.
1. Activate the plugin through the 'Plugins' menu in WordPress.

## Frequently Asked Questions ##

### Shortcode does not turn into graph ###

Pay attention that to turn your shortcodes into graphs, your theme has to have `<?php wp_footer(); ?>` call at the bottom of **footer.php** file.

### Is there any documentation available for this plugin? ###

[http://docs.themeisle.com/article/428-visualizer-charts-and-graphs-documentation](http://docs.themeisle.com/article/428-visualizer-charts-and-graphs-documentation)

### How to format chart series values? ###

[http://docs.themeisle.com/article/672-how-to-format-series-values](http://docs.themeisle.com/article/672-how-to-format-series-values)

### How to create charts from your WordPress posts? ###

[http://docs.themeisle.com/article/673-how-to-create-charts-from-your-wordpress-posts](http://docs.themeisle.com/article/673-how-to-create-charts-from-your-wordpress-posts)

### How to automatically sync charts with online files? ###

[http://docs.themeisle.com/article/674-how-to-automatically-sync-charts-with-online-files](http://docs.themeisle.com/article/674-how-to-automatically-sync-charts-with-online-files)

### How can I create a chart? ###

[http://docs.themeisle.com/article/597-create-chart](http://docs.themeisle.com/article/597-create-chart)

### How can I edit a chart? ###

[http://docs.themeisle.com/article/602-how-can-i-edit-a-chart](http://docs.themeisle.com/article/602-how-can-i-edit-a-chart)

### How can I delete a chart? ###

[http://docs.themeisle.com/article/600-delete-chart](http://docs.themeisle.com/article/600-delete-chart)

### How can I clone a chart? ###

[http://docs.themeisle.com/article/598-clone-chart](http://docs.themeisle.com/article/598-clone-chart)

### How can I highlight a single bar? ###

[http://docs.themeisle.com/article/603-how-can-i-highlight-a-single-bar](http://docs.themeisle.com/article/603-how-can-i-highlight-a-single-bar)

### How can I populate chart series and data dynamically? ###

[http://docs.themeisle.com/article/605-how-can-i-populate-chart-series-and-data-dynamically](http://docs.themeisle.com/article/605-how-can-i-populate-chart-series-and-data-dynamically)

### How can I populate data from Google Spreadsheet? ###

[http://docs.themeisle.com/article/607-how-can-i-populate-data-from-google-spreadsheet](http://docs.themeisle.com/article/607-how-can-i-populate-data-from-google-spreadsheet)

### How can i import content from another chart? ###

[http://docs.themeisle.com/article/609-how-can-i-import-content-from-another-chart](http://docs.themeisle.com/article/609-how-can-i-import-content-from-another-chart)

### How to export a chart? ###

[http://docs.themeisle.com/article/608-how-to-export-a-chart](http://docs.themeisle.com/article/608-how-to-export-a-chart)

### How can i edit the data manually? ###

[http://docs.themeisle.com/article/610-how-can-i-edit-the-data-manually](http://docs.themeisle.com/article/610-how-can-i-edit-the-data-manually)

### How to enable frontend action buttons? ###

[http://docs.themeisle.com/article/675-how-to-enable-frontend-action-buttons](http://docs.themeisle.com/article/675-how-to-enable-frontend-action-buttons)
### How to use Google Visualization variables? ###

[http://docs.themeisle.com/article/691-how-to-use-google-visualization-variables](http://docs.themeisle.com/article/691-how-to-use-google-visualization-variables)

## Screenshots ##

1. Chart type selection
2. Chart data uploading
3. Chart options editing
4. Charts media library
5. Charts library

## Changelog ##
### 3.2.1 - 2019-05-05  ###

* Fix issue with async loading of scripts


### 3.2.0 - 2019-05-03  ###

* Add support for charts in AMP requests
* Add support to show charts from JSON/REST endpoints
* Fix loading of Google Visualization javascript files
* Add simple editors for editing chart data
* Tested up to WP 5.2


### 3.1.3 - 2019-02-24  ###

* Fix issue with changing column settings of the last column in table chart
* Add support for query language to get subset of data from Google Spreadsheet
* Fix conflict with jquery 3.3.x
* Migrated PHPExcel to PhpSpreadsheet
* Front end action 'print' should print the chart and fall back to printing the data
* Fix issue with table chart not showing in IE
* Fix issue with multiple instances of same chart not showing
* Fix issue with date type column does not work with Combo charts
* Tested with WP 5.1


### 3.1.2 - 2018-12-06  ###

* Fix bug "Warning: A non-numeric value encountered"
* Tested with WP 5.0


### 3.1.1 - 2018-12-05  ###

* Fix issue with Gutenberg support
* Fix issue with loading new Table chart
* Fix options that don't work correctly with some charts


### 3.1.0 - 2018-12-03  ###

* Add Table chart
* Fix date format in sample files


### 3.0.12 - 2018-10-11  ###

* Added filter to enable users to change schedule of charts.
* Fixed bug with line chart with timeofday column.
* Fixed bug with scheduled charts that sometimes did not show updated data.
* Javascript can be customized on a per user basis that will not be wiped out on update.


### 3.0.11 - 2018-08-15  ###

* Fixed issue with the Series Settings options for the Table Chart
* Fixed issue with chart showing "Table has no columns" with remote sources


### 3.0.10 - 2018-07-20  ###

* Fixed problem with chart reverting to the default values
* Fixed problem with Boolean column type
* Fixed problem with the Geo chart type not saving colors options


### 3.0.9 - 2018-07-12  ###

* New chart title option for the back-end of the charts that don't allow a title on the front-end
* Store the png images of the charts in a global array that can be used in JS
* Added options for charts animations


### 3.0.8 - 2018-06-27  ###

* Added revision support for the chart post type
* Added both % and Value to the Pie Slice
* Use the blog locale for Visualizer's options
* Fixed issue with data being fetched from the remote source every single time the chart was shown
* Fixed issue with scheduled charts not being updated if one of the scheduled charts is deleted


### 3.0.7 - 2018-03-26  ###

* Adds insert button in chart library.
* Remove frontend assets where they are not needed.
* Improve non-English charts compatibility. 
* Adds a filter to change charts locale.


### 3.0.6 - 2018-02-27  ###

* Fix UTF-8 support while saving the data. 
* Improve editing experience.  
* Improves compatibility with Premium version. 
* Adds chart button into TinyMCE editor.


### 3.0.5 - 2018-01-05  ###

* Fix chart rendering bug in firefox.
* Fix review notification.


### 3.0.4 - 2017-11-27  ###

* Fix for review message notification.


### 3.0.3 - 2017-11-16  ###

* Adds compatibility with WordPress 4.9.


### 3.0.2 - 2017-10-10  ###

* Fix dependency for composer dependencies.


### 3.0.1 - 2017-10-06  ###

* Improved compatibility with various theme and plugins.
* Fix for chart type selection when creation from media popup.


### 3.0.0 - 2017-09-05  ###

* Adds support manual configuration according to Google Visualization API.
* Improves compatibility with more features from the pro version.


### 2.2.0 - 2017-08-16  ###

* Added custom number format for pie chart.
* Added frontend actions buttons ( Print, Export to CSV, Export to Excel, Copy)


### 2.1.9 - 2017-07-10  ###

* Fixed display error with hex color.


### 2.1.8 - 2017-07-03  ###

* Added chart title into library. 
* Fixed SDK issues with dashboard widget.


### 2.1.7 ###

* Updated sdk loading logic.



### 2.1.4 ###
* Fixed issues with non-latin chars on CSV files to import.

### 2.1.2 ###
* Fixed priority issue with wp_enqueue_media
* Added latest version of sdk

### 2.1.1 ###
* Fixed charts bliking on some themes.

### 2.1.0 ###
* Fixed geomap issue with apikey.
* Fixed responsive issues on tabbed interface and page builders.
* Added compatibility with premium import from posts/page feature.

### 2.0.4 ###
* Fixed resize issue in the library page.

### 2.0.0 ###
* Improved design and layout to support multiple datasources.
* Added new integrations in the Pro version.
* Added opt-in for tracking.

### 1.7.6 ###
* Fixed issue when using the same shortcode multiple times on the same page.

### 1.7.5 ###
* Removed footer banner upsell
* Fixed series settings issue
* Fixed issue with comas being used in numbers

### 1.7.2 ###
* Improved charts responsive system

### 1.7.1 ###
* Fixed grid lines error links

### 1.7.0 ###
* Fixed responsive issues
* Fixed issues with zero margin values
* Fixed import issue

### 1.6.6 ###
* Fixed charts resizing on tabbed content

### 1.6.5 ###
* Fixed responsive issue
* Fixed no axis text color for line and bar charts


### 1.6.0 ###
* Fixed security issue when importing charts
* Removed pointer for the pro version
* Fixed charts import from media library
* Added support to show legend on the left side


### 1.5.6 ###
* Added support for 3 more chart types
* Fixed issue with charts not saving


### 1.5.5 ###
* Added export for charts
* Enable default value for focus target. Fixed issue with hover which was not working on some machines.


### 1.5.4 ###
* Added free search text over graphs

### 1.5.2 ###
* Added step2 and 3 into step 1

### 1.5.1 ###
* Fixed bug with from web button

### 1.5 ###
* Added support for live editor
* Added support for importing data from other charts
* Added filter for chart settings
* Fixed bug when zero was not working on the charts

### 1.4.2.3 ###
* Implemented ability to edit horizontal and vertical axis number format for bar and column charts

### 1.4.2.2 ###
* Added ability to pass a class for chart wrapper div
* Added proper label for custom post type

### 1.4.2.1 ###
* Fixed issue with download_url function which not exists at front end
* Added functionality which prevents direct access to the plugin folder

### 1.4.2 ###
* Fixed remote CSV uploading issue when allow_url_fopen option is disabled in php.ini
* Replaced flattr image on widget and added donate link to plugin meta data
* Added notification message at library page when allow_url_fopen option is disabled

### 1.4.1.1 ###
* Removed CSV parser escape constant to prevent warnings which appears when PHP 5.2.x or less is used

### 1.4.1 ###
* Fixed issue which prevents the plugin working on SSL backend
* Fixed issue with CSV file uploading in IE and other browsers
* Fixed issue with empty series, which appears due to leading space in a source file
* Added ability to define custom delimiter, enclosure and escape variables for CSV parsing

### 1.4 ###
* Implemented aggregation target and selection mode options for candlestick chart
* Implemented focus target and data opacity for columnar chars
* Implemented data opacity and interpolate nulls settings for line chart
* Implemented ability to edit tooltip settings
* Implemented new settings for linear charts like selection mode and aggregation target
* Implemented area and point opacity settings for area chart
* Implemented new settings for pie chart like pie hole, start angle and slice offset
* Implemented ability to select a color for chart title and legend items
* Fixed number formatting settings for linear charts, from now it works only for axis labels
* Reworked general settings section by moving title and font settings into separate groups

### 1.3.0.2 ###
* Replaced links to github wiki

### 1.3.0.1 ###
* Added Flattr button

### 1.3.0 ###
* Implemented ability to set number and date formatters
* Implemented ability to select transparent background for a chart
* Fixed JS bugs which appear when post type editor support is disabled
* Fixed issue with NULL values for numeric series
* Fixed invalid charts rendering at "Add Media" library
* Fixed compatibility issue with another Google API related plugins
* Added "rate the plugin" box

### 1.2.0 ###
* Implemented minor grid lines settings.
* Implemented view window settings.
* Horizontal and vertical axes settings were split into separate groups.

### 1.1.4 ###
* Bug with float values has been fixed.

### 1.1.3 ###
* Issue with "fseek warning" for Google Spreadsheet document source, was fixed.

### 1.1.2 ###
* Compatibility issues with WordPress version 3.6 has been fixed.

### 1.1.1 ###
* Active type tab in the charts library was fixed.
* Library styles were updated.

### 1.1.0 ###
* Auto population was added for remote CSV file source.
* Ability to hook chart series and data was implemented.
* Ability to upload CSV files from web was implemented.

### 1.0.1 ###
* The bug with CSV file uploading was fixed.

### 1.0.0 ###
* The first version of what wil be the best wp charts plugin.
